"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var debug_flags_exports = {};
__export(debug_flags_exports, {
  debugFlags: () => debugFlags,
  featureFlags: () => featureFlags,
  pointerCaptureTrackingObject: () => pointerCaptureTrackingObject
});
module.exports = __toCommonJS(debug_flags_exports);
var import_state = require("@tldraw/state");
var import_utils = require("@tldraw/utils");
const featureFlags = {
  enableLicensing: createFeatureFlag("enableLicensing", {
    defaults: { all: true, production: false }
  })
};
const pointerCaptureTrackingObject = createDebugValue(
  "pointerCaptureTrackingObject",
  // ideally we wouldn't store this mutable value in an atom but it's not
  // a big deal for debug values
  {
    defaults: { all: /* @__PURE__ */ new Map() },
    shouldStoreForSession: false
  }
);
const debugFlags = {
  // --- DEBUG VALUES ---
  logPreventDefaults: createDebugValue("logPreventDefaults", {
    defaults: { all: false }
  }),
  logPointerCaptures: createDebugValue("logPointerCaptures", {
    defaults: { all: false }
  }),
  logElementRemoves: createDebugValue("logElementRemoves", {
    defaults: { all: false }
  }),
  debugSvg: createDebugValue("debugSvg", {
    defaults: { all: false }
  }),
  showFps: createDebugValue("showFps", {
    defaults: { all: false }
  }),
  measurePerformance: createDebugValue("measurePerformance", { defaults: { all: false } }),
  throwToBlob: createDebugValue("throwToBlob", {
    defaults: { all: false }
  }),
  reconnectOnPing: createDebugValue("reconnectOnPing", {
    defaults: { all: false }
  }),
  debugCursors: createDebugValue("debugCursors", {
    defaults: { all: false }
  }),
  forceSrgb: createDebugValue("forceSrgbColors", { defaults: { all: false } }),
  debugGeometry: createDebugValue("debugGeometry", { defaults: { all: false } }),
  hideShapes: createDebugValue("hideShapes", { defaults: { all: false } }),
  editOnType: createDebugValue("editOnType", { defaults: { all: false } })
};
if (typeof Element !== "undefined") {
  const nativeElementRemoveChild = Element.prototype.removeChild;
  (0, import_state.react)("element removal logging", () => {
    if (debugFlags.logElementRemoves.get()) {
      Element.prototype.removeChild = function(child) {
        console.warn("[tldraw] removing child:", child);
        return nativeElementRemoveChild.call(this, child);
      };
    } else {
      Element.prototype.removeChild = nativeElementRemoveChild;
    }
  });
}
function createDebugValue(name, {
  defaults,
  shouldStoreForSession = true
}) {
  return createDebugValueBase({
    name,
    defaults,
    shouldStoreForSession
  });
}
function createFeatureFlag(name, {
  defaults,
  shouldStoreForSession = true
}) {
  return createDebugValueBase({
    name,
    defaults,
    shouldStoreForSession
  });
}
function createDebugValueBase(def) {
  const defaultValue = getDefaultValue(def);
  const storedValue = def.shouldStoreForSession ? getStoredInitialValue(def.name) : null;
  const valueAtom = (0, import_state.atom)(`debug:${def.name}`, storedValue ?? defaultValue);
  if (typeof window !== "undefined") {
    if (def.shouldStoreForSession) {
      (0, import_state.react)(`debug:${def.name}`, () => {
        const currentValue = valueAtom.get();
        if (currentValue === defaultValue) {
          (0, import_utils.deleteFromSessionStorage)(`tldraw_debug:${def.name}`);
        } else {
          (0, import_utils.setInSessionStorage)(`tldraw_debug:${def.name}`, JSON.stringify(currentValue));
        }
      });
    }
    Object.defineProperty(window, `tldraw${def.name.replace(/^[a-z]/, (l) => l.toUpperCase())}`, {
      get() {
        return valueAtom.get();
      },
      set(newValue) {
        valueAtom.set(newValue);
      },
      configurable: true
    });
  }
  return Object.assign(valueAtom, def);
}
function getStoredInitialValue(name) {
  try {
    return JSON.parse((0, import_utils.getFromSessionStorage)(`tldraw_debug:${name}`) ?? "null");
  } catch (err) {
    return null;
  }
}
function readEnv(fn) {
  try {
    return fn();
  } catch {
    return null;
  }
}
function getDefaultValue(def) {
  const env = readEnv(() => process.env.TLDRAW_ENV) ?? readEnv(() => process.env.VERCEL_PUBLIC_TLDRAW_ENV) ?? readEnv(() => process.env.NEXT_PUBLIC_TLDRAW_ENV) ?? // default to production because if we don't have one of these, this is probably a library use
  "production";
  switch (env) {
    case "production":
      return def.defaults.production ?? def.defaults.all;
    case "preview":
    case "staging":
      return def.defaults.staging ?? def.defaults.all;
    default:
      return def.defaults.development ?? def.defaults.all;
  }
}
//# sourceMappingURL=debug-flags.js.map
